<?php

/**
 * Plugin Name:       StatusPage Widget
 * Plugin URI:        https://github.com/hosted-status-page/wordpress-status-page-widget
 * Description:       Display real-time status page widgets from StatusPage.me on your WordPress site. Includes Gutenberg block, classic widget, and shortcodes.
 * Version:           1.0.1
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            StatusPage.me
 * Author URI:        https://statuspage.me
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       status-page-widget
 * Domain Path:       /languages
 * Update URI:        https://github.com/hosted-status-page/wordpress-status-page-widget
 *
 * @package StatusPageWidget
 */

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

// Plugin version.
define('STATUSPAGE_WIDGET_VERSION', '1.0.1');

// Plugin directory path.
define('STATUSPAGE_WIDGET_PATH', plugin_dir_path(__FILE__));

// Plugin directory URL.
define('STATUSPAGE_WIDGET_URL', plugin_dir_url(__FILE__));

// API base URL.
define('STATUSPAGE_API_BASE', 'https://statuspage.me');

/**
 * Load plugin textdomain.
 */
function statuspage_widget_load_textdomain()
{
    load_plugin_textdomain(
        'status-page-widget',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages'
    );
}
add_action('plugins_loaded', 'statuspage_widget_load_textdomain');

// Include required files.
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-api.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-renderer.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-shortcodes.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-classic-widget.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-block.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-updater.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-settings.php';
require_once STATUSPAGE_WIDGET_PATH . 'includes/class-statuspage-admin.php';

/**
 * Initialize the plugin.
 */
function statuspage_widget_init()
{
    // Initialize API.
    StatusPage_API::init();

    // Initialize shortcodes.
    StatusPage_Shortcodes::init();

    // Initialize classic widget.
    add_action('widgets_init', function () {
        register_widget('StatusPage_Classic_Widget');
    });

    // Initialize Gutenberg block.
    StatusPage_Block::init();

    // Initialize GitHub updater.
    StatusPage_Updater::init();

    // Initialize admin (includes settings).
    StatusPage_Admin::init();
}
add_action('init', 'statuspage_widget_init');

/**
 * Enqueue frontend assets.
 */
function statuspage_widget_enqueue_assets()
{
    // Register the StatusPage embed script for JS mode.
    wp_register_script(
        'statuspage-embed',
        STATUSPAGE_API_BASE . '/static/embed/v1/status.min.js',
        array(),
        STATUSPAGE_WIDGET_VERSION,
        true
    );

    // Register frontend styles for PHP mode.
    wp_register_style(
        'status-page-widget-frontend',
        STATUSPAGE_WIDGET_URL . 'build/frontend.css',
        array(),
        STATUSPAGE_WIDGET_VERSION
    );
}
add_action('wp_enqueue_scripts', 'statuspage_widget_enqueue_assets');

/**
 * Plugin activation hook.
 */
function statuspage_widget_activate()
{
    // Flush rewrite rules on activation.
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'statuspage_widget_activate');

/**
 * Plugin deactivation hook.
 */
function statuspage_widget_deactivate()
{
    // Clean up transients.
    global $wpdb;
    $wpdb->query(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_statuspage_%' OR option_name LIKE '_transient_timeout_statuspage_%'"
    );

    // Flush rewrite rules on deactivation.
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'statuspage_widget_deactivate');
